/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.blocks.shafts;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlock;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import com.simibubi.create.foundation.placement.PoleHelper;
import fr.iglee42.createcasing.registries.ModBlockEntities;
import fr.iglee42.createcasing.registries.ModBlocks;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class WoodenShaftBlock
extends ShaftBlock {
    public static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public WoodenShaftBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntityType<? extends KineticBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.WOODEN_SHAFT.get();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ItemStack heldItem;
        InteractionResult result = super.m_6227_(state, world, pos, player, hand, ray);
        if (result != InteractionResult.PASS) {
            return result;
        }
        ItemStack item = player.m_21120_(hand);
        if (item.m_41720_().equals(Items.f_42755_)) {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)AXIS);
            world.m_46597_(pos, (BlockState)ModBlocks.MLDEG_SHAFT.getDefaultState().m_61124_((Property)AXIS, (Comparable)axis));
            return InteractionResult.SUCCESS;
        }
        if (item.m_204117_(ItemTags.f_13168_) && ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()).m_135827_().equals("minecraft")) {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)AXIS);
            world.m_46597_(pos, (BlockState)((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("createcasing", ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()).m_135815_().replace("_planks", "") + "_shaft"))).m_49966_().m_61124_((Property)AXIS, (Comparable)axis));
            return InteractionResult.SUCCESS;
        }
        IPlacementHelper helper = PlacementHelpers.get((int)placementHelperId);
        if (helper.matchesItem(heldItem = player.m_21120_(hand))) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
        }
        return InteractionResult.PASS;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction.Axis> {
        private PlacementHelper() {
            super(state -> state.m_60734_() instanceof AbstractSimpleShaftBlock || state.m_60734_() instanceof PoweredShaftBlock, state -> (Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS), (Property)RotatedPillarKineticBlock.AXIS);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.m_41720_() instanceof BlockItem && ((BlockItem)i.m_41720_()).m_40614_() instanceof AbstractSimpleShaftBlock;
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.m_60734_() instanceof ShaftBlock || AllBlocks.POWERED_LATCH.has(s);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            PlacementOffset offset = super.getOffset(player, world, state, pos, ray);
            if (offset.isSuccessful()) {
                offset.withTransform(offset.getTransform().andThen(s -> ShaftBlock.pickCorrectShaftType((BlockState)s, (Level)world, (BlockPos)offset.getBlockPos())));
            }
            return offset;
        }
    }
}

