/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.compat.kubejs.press;

import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.typings.Info;
import fr.iglee42.createcasing.api.CreateCasingApi;
import fr.iglee42.createcasing.compat.kubejs.CreateCasingBuilderBaseJS;
import fr.iglee42.createcasing.compat.kubejs.KubeJSCompatPlugin;
import net.minecraft.resources.ResourceLocation;

public class PressBuilderJs
extends CreateCasingBuilderBaseJS {
    private String casingTexture;
    private String topTexture;
    private String sideTexture;
    private String gearboxTexture;
    private String bottomTexture;

    public PressBuilderJs(String name) {
        super(name, name + "_press", "block");
        this.sideTexture = "kubejs:block/" + name + "_press_side";
        this.topTexture = "kubejs:block/" + name + "_press_top";
        this.bottomTexture = "kubejs:block/" + name + "_press_bottom";
        this.gearboxTexture = "kubejs:block/" + name + "_gearbox";
        this.casingTexture = "kubejs:block/" + name + "_casing";
    }

    public PressBuilderJs casingTexture(String texture) {
        this.casingTexture = texture;
        return this;
    }

    public PressBuilderJs topTexture(String texture) {
        this.topTexture = texture;
        return this;
    }

    public PressBuilderJs sideTexture(String texture) {
        this.sideTexture = texture;
        return this;
    }

    public PressBuilderJs bottomTexture(String texture) {
        this.bottomTexture = texture;
        return this;
    }

    public PressBuilderJs gearboxTexture(String texture) {
        this.gearboxTexture = texture;
        return this;
    }

    public PressBuilderJs displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public PressBuilderJs translationKey(String translationKey) {
        this.translationKey = translationKey;
        return this;
    }

    @Override
    public void generateAssetJsons(AssetJsonGenerator generator) {
        generator.blockState(new ResourceLocation("createcasing-kubejs", this.fullName), gen -> gen.simpleVariant("", "createcasing-kubejs:block/" + this.fullName));
        generator.blockModel(new ResourceLocation("createcasing-kubejs", this.fullName), mg -> {
            mg.parent("createcasing:block/api/press/block");
            mg.texture("4", this.sideTexture);
            mg.texture("mechanical_press_top", this.topTexture);
            mg.texture("mechanical_press_bottom", this.bottomTexture);
            mg.texture("gearbox", this.gearboxTexture);
            mg.texture("gearbox_top", this.casingTexture);
        });
        generator.itemModel(new ResourceLocation("createcasing-kubejs", this.fullName), mg -> {
            mg.parent("createcasing:block/api/press/item");
            mg.texture("8", this.sideTexture);
            mg.texture("mechanical_press_top", this.topTexture);
            mg.texture("mechanical_press_bottom", this.bottomTexture);
            mg.texture("gearbox", this.gearboxTexture);
            mg.texture("gearbox_top", this.casingTexture);
        });
    }

    @Info(value="Create the press in the code and return it")
    public void build() {
        CreateCasingApi.createPress(KubeJSCompatPlugin.REGISTRATE, this.name);
    }
}

