/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.impl;

import java.util.Arrays;
import java.util.function.Consumer;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowGeneric;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButton;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewPopup
extends View<Window<?, ?>> {
    public ViewPopup(@NotNull Window<?, ?> parent, String title, @Nullable Consumer<Workspace> callback, String ... text) {
        super(parent, title);
        ElementTextWrapper text1 = new ElementTextWrapper(this);
        if (text.length == 1) {
            text1.setText(text[0]);
        } else {
            text1.setText(Arrays.asList(text));
        }
        text1.setConstraint(new Constraint(text1).top(this, Constraint.Property.Type.TOP, 20).bottom(this, Constraint.Property.Type.BOTTOM, 40));
        this.elements.add(text1);
        ElementButton<ElementButton> button = new ElementButton<ElementButton>(this, I18n.m_118938_((String)"gui.ok", (Object[])new Object[0]), elementClickable -> {
            ((Workspace)parent.parent).removeWindow(parent);
            if (callback != null) {
                callback.accept((Workspace)parent.parent);
            }
        });
        button.setSize(60, 20);
        button.setConstraint(new Constraint(button).bottom(this, Constraint.Property.Type.BOTTOM, 20));
        this.elements.add(button);
    }

    @Override
    public void init() {
        super.init();
        ElementTextWrapper text = (ElementTextWrapper)this.elements.get(0);
        text.setWidth(Math.min(text.longestLine + 5, (int)((double)this.width * 0.9)));
        text.init();
    }

    @Override
    public void resize(Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
        ElementTextWrapper text = (ElementTextWrapper)this.elements.get(0);
        text.setWidth(Math.min(text.longestLine + 5, (int)((double)this.width * 0.9)));
        text.init();
    }

    @Override
    public void setWindowGenericProperties(WindowGeneric<?, ?> window) {
        window.disableDocking();
        window.disableDockStacking();
        window.disableUndocking();
        window.isNotUnique();
    }

    public static <W extends Workspace> void popup(W parent, double widthRatio, double heightRatio, Consumer<W> callback, String ... text) {
        ViewPopup.popup(parent, widthRatio, heightRatio, "window.popup.title", callback, text);
    }

    public static <W extends Workspace> void popup(W parent, double widthRatio, double heightRatio, String title, Consumer<W> callback, String ... text) {
        parent.openWindowInCenter((Window<?, ?>)WindowGeneric.create(parent, windowGeneric -> new ViewPopup((Window<?, ?>)windowGeneric, title, callback, text)), widthRatio, heightRatio, true);
    }
}

