/*
 * Decompiled with CFR 0.152.
 */
package com.mystchonky.tomeofblood;

import com.hollingsworth.arsnouveau.setup.proxy.ClientProxy;
import com.hollingsworth.arsnouveau.setup.proxy.IProxy;
import com.hollingsworth.arsnouveau.setup.proxy.ServerProxy;
import com.mystchonky.tomeofblood.client.registry.ParticleRegistry;
import com.mystchonky.tomeofblood.common.config.BaseConfig;
import com.mystchonky.tomeofblood.common.network.Networking;
import com.mystchonky.tomeofblood.common.registry.IntegrationRegistry;
import com.mystchonky.tomeofblood.common.registry.ItemRegistry;
import com.mystchonky.tomeofblood.common.registry.LangRegistry;
import com.mystchonky.tomeofblood.common.registry.LivingUpgradeRegistry;
import com.mystchonky.tomeofblood.common.registry.MobEffectRegistry;
import com.tterrag.registrate.Registrate;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tomeofblood")
public class TomeOfBlood {
    public static final String MODID = "tomeofblood";
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    private static final Lazy<Registrate> REGISTRATE = Lazy.of(() -> Registrate.create((String)MODID));
    public static final Logger LOGGER = LogManager.getLogger();

    public static Registrate registrate() {
        return (Registrate)REGISTRATE.get();
    }

    public TomeOfBlood() {
        try {
            Files.createDirectories(FMLPaths.CONFIGDIR.get().resolve(MODID), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ModLoadingContext ctx = ModLoadingContext.get();
        ctx.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BaseConfig.COMMON_SPEC, "tomeofblood/base-common.toml");
        ctx.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)BaseConfig.CLIENT_SPEC, "tomeofblood/base-client.toml");
        ItemRegistry.register();
        LivingUpgradeRegistry.register();
        MobEffectRegistry.register();
        ParticleRegistry.register();
        IntegrationRegistry.init();
        LangRegistry.register();
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        modbus.addListener(this::setup);
        modbus.addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static ResourceLocation prefix(String path) {
        return new ResourceLocation(MODID, path);
    }

    private void setup(FMLCommonSetupEvent event) {
        IntegrationRegistry.postInit();
        Networking.registerMessages();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }
}

