/*
 * Decompiled with CFR 0.152.
 */
package com.mystchonky.tomeofblood.common.items;

import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.mystchonky.tomeofblood.client.renderer.item.TomeOfBloodRenderer;
import com.mystchonky.tomeofblood.common.spell.BloodSpellResolver;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class TomeOfBloodItem
extends SpellBook {
    public TomeOfBloodItem(Item.Properties properties, SpellTier tier) {
        super(properties, tier);
        this.tier = tier;
    }

    @NotNull
    public ISpellCaster getSpellCaster(ItemStack stack) {
        return new BloodBookCaster(stack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new TomeOfBloodRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public static class BloodBookCaster
    extends SpellBook.BookCaster {
        public BloodBookCaster(ItemStack stack) {
            super(stack);
        }

        public SpellResolver getSpellResolver(SpellContext context, Level worldIn, LivingEntity playerIn, InteractionHand handIn) {
            return new BloodSpellResolver(context);
        }
    }
}

