/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.handlers;

import com.mojang.blaze3d.platform.Window;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class DescriptionHandler {
    private static final int REQUIRED_TIME = 20;
    private static int ticksCount;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!player.m_9236_().m_5776_()) {
            return;
        }
        boolean hasShiftDown = Screen.m_96638_();
        if (ticksCount > 0 && !hasShiftDown) {
            --ticksCount;
        }
        Minecraft MC = Minecraft.m_91087_();
        Screen screen = MC.f_91080_;
        if (!(screen instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
        Window window = MC.m_91268_();
        double mouseX = MC.f_91067_.m_91589_() * (double)window.m_85445_() / (double)window.m_85443_();
        double mouseY = MC.f_91067_.m_91594_() * (double)window.m_85446_() / (double)window.m_85444_();
        AbstractContainerMenu menu = player.f_36096_;
        Slot slot = null;
        int id = 0;
        for (int i = 0; i < menu.f_38839_.size(); ++i) {
            Slot entry = (Slot)menu.f_38839_.get(i);
            if (!DescriptionHandler.isHovering(screen2.getGuiLeft(), screen2.getGuiTop(), entry.f_40220_, entry.f_40221_, mouseX, mouseY)) continue;
            slot = entry;
            id = i;
            break;
        }
        if (slot == null) {
            return;
        }
        ItemStack stack = slot.m_7993_();
        if (!(stack.m_41720_() instanceof IRelicItem)) {
            return;
        }
        if (hasShiftDown && ++ticksCount >= 20) {
            RelicDescriptionScreen descriptionScreen = new RelicDescriptionScreen(player, player.f_36096_.f_38840_, id, Minecraft.m_91087_().f_91080_);
            descriptionScreen.stack = DescriptionUtils.gatherRelicStack(player, id);
            Minecraft.m_91087_().m_91152_((Screen)descriptionScreen);
            ticksCount = 0;
        }
    }

    protected static boolean isHovering(int leftPos, int topPos, int slotX, int slotY, double mouseX, double mouseY) {
        return (mouseX -= (double)leftPos) >= (double)(slotX - 1) && mouseX < (double)(slotX + 16 + 1) && (mouseY -= (double)topPos) >= (double)(slotY - 1) && mouseY < (double)(slotY + 16 + 1);
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (!(event.getItemStack().m_41720_() instanceof IRelicItem)) {
            return;
        }
        event.getToolTip().add(DescriptionHandler.drawProgressBar("||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||"));
    }

    public static MutableComponent drawProgressBar(String style) {
        StringBuilder string = new StringBuilder(style);
        float percentage = (float)ticksCount / 20.0f;
        int offset = (int)Math.min((double)string.length(), Math.floor((float)string.length() * percentage));
        MutableComponent component = Component.m_237113_((String)"");
        String start = string.substring(0, offset);
        int startColor = 1573171;
        int endColor = 2885731;
        for (int i = 0; i < offset; ++i) {
            float fraction = (float)i / (float)(offset - 1);
            int r = (int)((1.0f - fraction) * (float)(startColor >> 16 & 0xFF) + fraction * (float)(endColor >> 16 & 0xFF));
            int g = (int)((1.0f - fraction) * (float)(startColor >> 8 & 0xFF) + fraction * (float)(endColor >> 8 & 0xFF));
            int b = (int)((1.0f - fraction) * (float)(startColor & 0xFF) + fraction * (float)(endColor & 0xFF));
            int color = r << 16 | g << 8 | b;
            component.m_7220_((Component)Component.m_237113_((String)String.valueOf(start.charAt(i))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)color))));
        }
        component.m_7220_((Component)Component.m_237113_((String)string.substring(offset)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY)));
        return component;
    }
}

