/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.models.items;

import com.google.common.collect.ImmutableList;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class CurioModel
extends HumanoidModel<LivingEntity> {
    private final Item item;
    private final ModelPart root;

    private CurioModel(Item item, ModelPart root) {
        super(root);
        this.item = item;
        this.root = root;
    }

    public CurioModel(Item item) {
        this(item, CurioModel.constructRoot(item));
    }

    public static ModelLayerLocation getLayerLocation(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        return new ModelLayerLocation(new ResourceLocation(id.m_135827_(), id.m_135815_()), id.m_135815_());
    }

    public static ModelPart constructRoot(Item item) {
        return Minecraft.m_91087_().m_167973_().m_171103_(CurioModel.getLayerLocation(item));
    }

    public ModelPart getById(String id) {
        return switch (id) {
            case "head" -> this.f_102808_;
            case "hat" -> this.f_102809_;
            case "body" -> this.f_102810_;
            case "right_arm" -> this.f_102811_;
            case "left_arm" -> this.f_102812_;
            case "right_leg" -> this.f_102813_;
            case "left_leg" -> this.f_102814_;
            default -> this.root.m_171324_(id);
        };
    }

    @Nonnull
    protected Iterable<ModelPart> m_5607_() {
        Object object;
        Item item = this.item;
        if (item instanceof IRenderableCurio) {
            IRenderableCurio renderable = (IRenderableCurio)item;
            object = renderable.headParts().stream().map(this::getById).toList();
        } else {
            object = ImmutableList.of();
        }
        return object;
    }

    @Nonnull
    protected Iterable<ModelPart> m_5608_() {
        Object object;
        Item item = this.item;
        if (item instanceof IRenderableCurio) {
            IRenderableCurio renderable = (IRenderableCurio)item;
            object = renderable.bodyParts().stream().map(this::getById).toList();
        } else {
            object = ImmutableList.of();
        }
        return object;
    }

    public Item getItem() {
        return this.item;
    }

    public ModelPart getRoot() {
        return this.root;
    }
}

