/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.api.events.common.ContainerSlotClickEvent;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;

public class InfinityHamItem
extends RelicItem {
    private static final String TAG_POTION = "potion";
    public static final String TAG_PIECES = "pieces";
    private static final String TAG_CHARGE = "charge";

    public InfinityHamItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE));
    }

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("autophagy").stat(StatData.builder("feed").initialValue(1.0, 2.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(value, 1)).build()).build()).ability(AbilityData.builder("infusion").requiredLevel(5).stat(StatData.builder("duration").initialValue(1.0, 3.5).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.5).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.VILLAGE).build()).build();
    }

    @Override
    public List<ItemStack> processCreativeTab() {
        ItemStack stack = this.m_7968_();
        NBTUtils.setInt(stack, TAG_PIECES, 10);
        return Lists.newArrayList((Object[])new ItemStack[]{stack});
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        Player player;
        if (entityIn.f_19797_ % 20 != 0 || !(entityIn instanceof Player) || (player = (Player)entityIn).m_6117_()) {
            return;
        }
        int pieces = NBTUtils.getInt(stack, TAG_PIECES, 0);
        if (pieces >= 10) {
            return;
        }
        int charge = NBTUtils.getInt(stack, TAG_CHARGE, 0);
        if (charge >= 10) {
            NBTUtils.setInt(stack, TAG_PIECES, pieces + 1);
            NBTUtils.setInt(stack, TAG_CHARGE, 0);
        } else {
            NBTUtils.setInt(stack, TAG_CHARGE, charge + 1);
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (NBTUtils.getInt(stack, TAG_PIECES, 0) > 0 && (player.m_36324_().m_38721_() || player.m_7500_())) {
            player.m_6672_(hand);
        }
        return super.m_7203_(world, player, hand);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int count) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.m_36324_().m_38721_() && !player.m_7500_()) {
            player.m_5810_();
            return;
        }
        if (player.f_19797_ % 10 != 0) {
            return;
        }
        int pieces = NBTUtils.getInt(stack, TAG_PIECES, 0);
        CompoundTag nbt = stack.m_41784_();
        if (pieces > 0) {
            NBTUtils.setInt(stack, TAG_PIECES, --pieces);
            int feed = (int)Math.round(this.getAbilityValue(stack, "autophagy", "feed"));
            player.m_36324_().m_38707_(feed, (float)feed);
            this.spreadExperience((LivingEntity)player, stack, Math.max(1, Math.min(20 - player.m_36324_().m_38702_(), feed)));
            if (!this.canUseAbility(stack, "infusion") || !nbt.m_128425_(TAG_POTION, 9)) {
                return;
            }
            int duration = (int)Math.round(this.getAbilityValue(stack, "infusion", "duration") * 20.0);
            ListTag list = nbt.m_128437_(TAG_POTION, 10);
            for (int i = 0; i < list.size(); ++i) {
                MobEffectInstance effect = MobEffectInstance.m_19560_((CompoundTag)list.m_128728_(i));
                if (effect == null || effect.m_19544_().m_8093_()) continue;
                MobEffectInstance currentEffect = player.m_21124_(effect.m_19544_());
                player.m_7292_(new MobEffectInstance(effect.m_19544_(), currentEffect == null ? duration : currentEffect.m_19557_() + duration, effect.m_19564_()));
            }
            if (pieces <= 0 && nbt.m_128441_(TAG_POTION)) {
                nbt.m_128473_(TAG_POTION);
            }
        } else {
            player.m_5810_();
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41784_().m_128441_(TAG_POTION);
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 50;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.EAT;
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onSlotClick(ContainerSlotClickEvent event) {
            InfinityHamItem relic;
            Item item;
            if (event.getAction() != ClickAction.PRIMARY) {
                return;
            }
            Player player = event.getEntity();
            ItemStack heldStack = event.getHeldStack();
            ItemStack slotStack = event.getSlotStack();
            if (!(heldStack.m_41720_() instanceof PotionItem && (item = slotStack.m_41720_()) instanceof InfinityHamItem && (relic = (InfinityHamItem)item).canUseAbility(slotStack, "infusion"))) {
                return;
            }
            CompoundTag tag = slotStack.m_41784_();
            ListTag list = tag.m_128437_(InfinityHamItem.TAG_POTION, 9);
            List<MobEffectInstance> effects = PotionUtils.m_43547_((ItemStack)heldStack);
            if (effects.isEmpty()) {
                NBTUtils.clearTag(slotStack, InfinityHamItem.TAG_POTION);
            } else {
                if ((effects = effects.stream().filter(effect -> effect != null && !effect.m_19544_().m_8093_()).toList()).isEmpty()) {
                    return;
                }
                for (MobEffectInstance effect2 : effects) {
                    list.add((Object)effect2.m_19555_(new CompoundTag()));
                }
                tag.m_128365_(InfinityHamItem.TAG_POTION, (Tag)list);
            }
            ItemStack bottle = new ItemStack((ItemLike)Items.f_42590_);
            if (player.f_36096_.m_142621_().m_41613_() <= 1) {
                player.f_36096_.m_142503_(bottle);
            } else {
                player.f_36096_.m_142621_().m_41774_(1);
                EntityUtils.addItem(player, bottle);
            }
            player.m_5496_(SoundEvents.f_11770_, 1.0f, 1.0f);
            event.setCanceled(true);
        }
    }
}

