/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.tile;

import net.mehvahdjukaar.amendments.common.LiquidMixer;
import net.mehvahdjukaar.amendments.common.block.DyeCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.LiquidCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LiquidCauldronBlockTile
extends BlockEntity
implements IExtraModelDataProvider,
ISoftFluidTankProvider {
    public static final ModelDataKey<SoftFluid> FLUID = new ModelDataKey(SoftFluid.class);
    private final SoftFluidTank fluidTank;

    public SoftFluidTank makeTank(BlockState blockState) {
        return blockState.m_60734_() instanceof DyeCauldronBlock ? this.createCauldronDyeTank() : this.createCauldronLiquidTank();
    }

    private boolean canMixPotions() {
        CommonConfigs.MixingMode config = CommonConfigs.POTION_MIXING.get();
        return config == CommonConfigs.MixingMode.ON || config == CommonConfigs.MixingMode.ONLY_BOILING && (Boolean)this.m_58900_().m_61143_((Property)LiquidCauldronBlock.BOILING) != false;
    }

    public LiquidCauldronBlockTile(BlockPos blockPos, BlockState blockState) {
        super(ModRegistry.LIQUID_CAULDRON_TILE.get(), blockPos, blockState);
        this.fluidTank = this.makeTank(blockState);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(FLUID, (Object)this.fluidTank.getFluidValue());
    }

    public SoftFluidTank getSoftFluidTank() {
        return this.fluidTank;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.fluidTank.load(compound);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.fluidTank.refreshTintCache();
            this.requestModelReload();
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.fluidTank.save(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_6596_() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        BlockState state = this.m_58900_();
        Block block = state.m_60734_();
        if (block instanceof ModCauldronBlock) {
            ModCauldronBlock cb = (ModCauldronBlock)block;
            state = cb.updateStateOnFluidChange(state, this.f_58857_, this.f_58858_, this.fluidTank.getFluid());
        }
        if (state != this.m_58900_()) {
            this.f_58857_.m_46597_(this.f_58858_, state);
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), state, 2);
        super.m_6596_();
    }

    public boolean handleInteraction(Player player, InteractionHand hand) {
        if (this.fluidTank.interactWithPlayer(player, hand, this.f_58857_, this.f_58858_)) {
            this.m_6596_();
            return true;
        }
        return false;
    }

    public void consumeOneLayer() {
        this.fluidTank.getFluid().shrink(1);
        this.m_6596_();
    }

    public SoftFluidTank createCauldronLiquidTank() {
        return new SoftFluidTank(PlatHelper.getPlatform().isFabric() ? 3 : 4){

            public boolean isFluidCompatible(SoftFluidStack fluidStack) {
                if (fluidStack.is((SoftFluid)BuiltInSoftFluids.WATER.get())) {
                    return false;
                }
                if (LiquidCauldronBlockTile.this.canMixPotions() && fluidStack.is((SoftFluid)BuiltInSoftFluids.POTION.get()) && fluidStack.is(this.getFluidValue())) {
                    return this.fluidStack.getTag().m_128461_("Bottle").equals(fluidStack.getTag().m_128461_("Bottle"));
                }
                return super.isFluidCompatible(fluidStack);
            }

            protected void addFluidOntoExisting(SoftFluidStack incoming) {
                if (LiquidCauldronBlockTile.this.canMixPotions() && incoming.is((SoftFluid)BuiltInSoftFluids.POTION.get())) {
                    LiquidMixer.mixPotions(this.fluidStack, incoming);
                    this.needsColorRefresh = true;
                }
                super.addFluidOntoExisting(incoming);
            }
        };
    }

    public SoftFluidTank createCauldronDyeTank() {
        return new SoftFluidTank(3){

            public boolean isFluidCompatible(SoftFluidStack fluidStack) {
                if (fluidStack.is((SoftFluid)ModRegistry.DYE_SOFT_FLUID.get()) && fluidStack.is(this.getFluidValue())) {
                    return true;
                }
                return super.isFluidCompatible(fluidStack);
            }

            protected void addFluidOntoExisting(SoftFluidStack fluidStack) {
                if (fluidStack.is((SoftFluid)ModRegistry.DYE_SOFT_FLUID.get())) {
                    LiquidMixer.mixDye(this.fluidStack, fluidStack);
                }
                super.addFluidOntoExisting(fluidStack);
            }
        };
    }
}

